IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[CRS].[FK_STD_QUESTION_STD_SURVEY_TYPE]') AND parent_object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]'))
ALTER TABLE [CRS].[STD_QUESTION] DROP CONSTRAINT [FK_STD_QUESTION_STD_SURVEY_TYPE]
GO

/****** Object:  Index [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID]    Script Date: 2/26/2018 10:26:23 AM ******/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]') AND name = N'IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID')
DROP INDEX [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID] ON [CRS].[STD_QUESTION]
GO

/****** Object:  Table [CRS].[STD_QUESTION_TYPE]    Script Date: 2/26/2018 10:26:23 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION_TYPE]') AND type in (N'U'))
DROP TABLE [CRS].[STD_QUESTION_TYPE]
GO

/****** Object:  Table [CRS].[STD_QUESTION]    Script Date: 2/26/2018 10:26:23 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF COL_LENGTH('[CRS].[STD_QUESTION]', 'STD_QUESTION_TYPE_ID') IS NOT NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] DROP COLUMN [STD_QUESTION_TYPE_ID]
	PRINT '[CRS].[STD_QUESTION].STD_QUESTION_TYPE_ID column deleted.'
END
IF COL_LENGTH('[CRS].[STD_QUESTION]', 'UNIT_HINT') IS NOT NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] DROP COLUMN [UNIT_HINT]
	PRINT '[CRS].[STD_QUESTION].[UNIT_HINT] column deleted.'
END
IF COL_LENGTH('[CRS].[STD_QUESTION]', 'EXTERNAL_DATA_ID') IS NOT NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] DROP COLUMN [EXTERNAL_DATA_ID]
	PRINT '[CRS].[STD_QUESTION].[EXTERNAL_DATA_ID] column deleted.'
END
GO

SET ANSI_PADDING OFF
GO


/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_getitemsBySurvey]    Script Date: 4/24/2018 2:17:58 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_getitemsBySurvey]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_QUESTION_getitemsBySurvey]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_getitemsBySurvey]    Script Date: 4/24/2018 2:17:58 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_getitemsBySurvey]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get all records by Survey
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_QUESTION_getitemsBySurvey] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @STD_SURVEY_TYPE_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_getitemsBySurvey'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT * FROM [CRS].[STD_QUESTION] WHERE [INACTIVE_FLAG] = 0 AND [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID;
END
' 
END
GO


/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_save]    Script Date: 4/24/2018 2:16:37 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_save]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_QUESTION_save]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_save]    Script Date: 4/24/2018 2:16:37 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_save]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Save/Update a record
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_QUESTION_save] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CREATED datetime, @CREATEDBY varchar(30), @ID int output, @INACTIVE_DATE datetime, @INACTIVE_FLAG bit, @QUESTION_NUMBER varchar(50), @QUESTION_TEXT varchar(950), @SORT_ORDER int, @STD_SURVEY_TYPE_ID int, @UPDATED datetime, @UPDATEDBY varchar(30))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUserRole](@CURRENT_USER, @CURRENT_REGISTRY_ID, ''CRSADMIN,REGADMIN'') = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_save'', @ErrorMsg, ''User is not part of an Admin Role'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

    IF (EXISTS(SELECT [ID] FROM [CRS].[STD_QUESTION] WHERE [ID] <> @ID AND ([STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND [QUESTION_NUMBER] = @QUESTION_NUMBER AND [QUESTION_TEXT] = @QUESTION_TEXT AND [INACTIVE_FLAG] = 0)))
    BEGIN
		SET @ErrorMsg = ''The Survey Field you are saving already exists'';
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
    END

	IF ISNULL(@ID,0) = 0
		BEGIN
			-- if insert then set CREATED to current date time
			SET @CREATED = GetDate();
			-- if insert then set UPDATED to current date time
			SET @UPDATED = GetDate();
			INSERT INTO [CRS].[STD_QUESTION] ([CREATED], [CREATEDBY], [INACTIVE_DATE], [INACTIVE_FLAG], [QUESTION_NUMBER], [QUESTION_TEXT], [SORT_ORDER], [STD_SURVEY_TYPE_ID], [UPDATED], [UPDATEDBY])
			VALUES (@CREATED, @CREATEDBY, @INACTIVE_DATE, @INACTIVE_FLAG, @QUESTION_NUMBER, @QUESTION_TEXT, @SORT_ORDER, @STD_SURVEY_TYPE_ID, @UPDATED, @UPDATEDBY);
			SELECT @ID = SCOPE_IDENTITY();
		END
	ELSE
		BEGIN
			DECLARE @OldValues varchar(max), @NewValues varchar(max);
			SELECT @OldValues = ''<CREATED>'' + ISNULL(CAST([CREATED] AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST([CREATEDBY] AS varchar), '''') + ''</CREATEDBY><ID>'' + ISNULL(CAST([ID] AS varchar), '''') + ''</ID><INACTIVE_DATE>'' + ISNULL(CAST([INACTIVE_DATE] AS varchar), '''') + ''</INACTIVE_DATE><INACTIVE_FLAG>'' + ISNULL(CAST([INACTIVE_FLAG] AS varchar), '''') + ''</INACTIVE_FLAG><QUESTION_NUMBER>'' + ISNULL(CAST([QUESTION_NUMBER] AS varchar), '''') + ''</QUESTION_NUMBER><QUESTION_TEXT>'' + ISNULL(CAST([QUESTION_TEXT] AS varchar), '''') + ''</QUESTION_TEXT><SORT_ORDER>'' + ISNULL(CAST([SORT_ORDER] AS varchar), '''') + ''</SORT_ORDER><STD_SURVEY_TYPE_ID>'' + ISNULL(CAST([STD_SURVEY_TYPE_ID] AS varchar), '''') + ''</STD_SURVEY_TYPE_ID><UPDATED>'' + ISNULL(CAST([UPDATED] AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST([UPDATEDBY] AS varchar), '''') + ''</UPDATEDBY>'' FROM [CRS].[STD_QUESTION] WHERE [ID] = @ID;
			SELECT @NewValues = ''<CREATED>'' + ISNULL(CAST(@CREATED AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST(@CREATEDBY AS varchar), '''') + ''</CREATEDBY><ID>'' + ISNULL(CAST(@ID AS varchar), '''') + ''</ID><INACTIVE_DATE>'' + ISNULL(CAST(@INACTIVE_DATE AS varchar), '''') + ''</INACTIVE_DATE><INACTIVE_FLAG>'' + ISNULL(CAST(@INACTIVE_FLAG AS varchar), '''') + ''</INACTIVE_FLAG><QUESTION_NUMBER>'' + ISNULL(CAST(@QUESTION_NUMBER AS varchar), '''') + ''</QUESTION_NUMBER><QUESTION_TEXT>'' + ISNULL(CAST(@QUESTION_TEXT AS varchar), '''') + ''</QUESTION_TEXT><SORT_ORDER>'' + ISNULL(CAST(@SORT_ORDER AS varchar), '''') + ''</SORT_ORDER><STD_SURVEY_TYPE_ID>'' + ISNULL(CAST(@STD_SURVEY_TYPE_ID AS varchar), '''') + ''</STD_SURVEY_TYPE_ID><UPDATED>'' + ISNULL(CAST(@UPDATED AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST(@UPDATEDBY AS varchar), '''') + ''</UPDATEDBY>'';
			SELECT @ErrorMsg = ''[CRS].[STD_QUESTION] values have been updated (Old Values:'' + @OldValues + '') to (New Values:'' + @NewValues + '') by ('' + @CURRENT_USER + '')'';
			EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_save'', @ErrorMsg, NULL, @CURRENT_USER;

			-- if update then set DateModified to current date time
			SET @UPDATED = GetDate();
			UPDATE [CRS].[STD_QUESTION] 
			SET
				[INACTIVE_DATE] = @INACTIVE_DATE
				, [INACTIVE_FLAG] = @INACTIVE_FLAG
				, [QUESTION_NUMBER] = @QUESTION_NUMBER
				, [QUESTION_TEXT] = @QUESTION_TEXT
				, [SORT_ORDER] = @SORT_ORDER
				, [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID
				, [UPDATED] = @UPDATED
				, [UPDATEDBY] = @UPDATEDBY
			WHERE
				[ID] = @ID;
		END
END
' 
END
GO

